/************************************************************************\
**  chargen.c - Character Generator Protocol                            **
**                                                                      **
**  Copyright (c) 2004 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	/* See RFC 864 for information about the CHARGEN protocol */


	#include <errno.h>
	#include <getopt.h>
	#include <signal.h>
	#include <stdarg.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/fcntl.h>

	#include "multiserv.h"
	#include "multiserv_utils.h"

	#include "chargen.h"

#if defined(MULTISERV_CHARGEN_TCP) || defined(MULTISERV_CHARGEN_UDP)
	static int chargen_fill_buffer(void);
#endif

/***********************************************************************
     TCP/IP routines
 **********************************************************************/
	
#if defined(MULTISERV_CHARGEN_TCP)

	int
chargen_tcp_description (FILE * stream)
{
	return (fprintf(stream, "Character Generator rfc.864 (TCP/IP)"));
}

	static int
chargen_tcp_dialog (int sock, struct sockaddr_in * unused_client_address)
{
	int n;
	multiserv_log(MULTISERV_LOG_MESSAGE, "chargen", "New TCP connection");
	do {
		n = chargen_fill_buffer();
	} while (send (sock, multiserv_buffer, n, 0) == n);
	multiserv_log(MULTISERV_LOG_MESSAGE, "chargen", "Connection closed by remote host");
	return (0);
}

	int
chargen_tcp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "chargen", "TCP server start");
	return (tcp_server(chargen_tcp_dialog));
}

#endif

/***********************************************************************
     UDP/IP routines
 **********************************************************************/

#if defined(MULTISERV_CHARGEN_UDP)

	int
chargen_udp_description (FILE * stream)
{
	return (fprintf(stream, "Character Generator rfc.864 (UDP/IP)"));
}

	static int
chargen_udp_dialog (int sock, struct sockaddr_in * client_address, int unused_msg_size)
{
	int n;
	multiserv_log(MULTISERV_LOG_MESSAGE, "chargen", "New UDP datagram");
	n = chargen_fill_buffer();
	sendto (sock, multiserv_buffer, n, 0, (struct sockaddr *) client_address,sizeof(struct sockaddr_in));
	return (0);
}

	int
chargen_udp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "chargen", "UDP server start");
	return (udp_simple_server(chargen_udp_dialog));
}  

#endif

/***********************************************************************
     Common routines
 **********************************************************************/

#if defined(MULTISERV_CHARGEN_TCP) || defined(MULTISERV_CHARGEN_UDP)

	static int
chargen_fill_buffer(void)
{
	#define LINE_LENGTH 72
	static int start = 0;
	int i, j;
	char * pattern = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
	for (i = start, j = 0; (j < LINE_LENGTH) && (pattern[i] != '\0'); i ++, j++)
		multiserv_buffer[j] = pattern[i];
	for (i = 0; (j < LINE_LENGTH) && (pattern[i] != '\0'); i++, j++)
		multiserv_buffer[j] = pattern[i];
	multiserv_buffer[j++] = '\r';
	multiserv_buffer[j++] = '\n';
	start ++;
	if (pattern[start] == '\0')
		start = 0;
	return (j);
}

#endif
