/************************************************************************\
**  daytime.c - Daytime Protocol                     			        **
**                                                                      **
**  Copyright (c) 2004 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	/* See RFC 867 for information about the DAYTIME protocol */

	#include <errno.h>
	#include <getopt.h>
	#include <signal.h>
	#include <stdarg.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <time.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/fcntl.h>

	#include "multiserv.h"
	#include "multiserv_utils.h"

	#include "daytime.h"

#if defined(MULTISERV_DAYTIME_TCP) || defined(MULTISERV_DAYTIME_UDP)

	static char *	format = "%c\n";
	static int		gmt_time = 1;

	static int	daytime_main (int proto, int argc, char * argv[]);

#endif

/***********************************************************************
     TCP/IP routines
 **********************************************************************/
	
#if defined(MULTISERV_DAYTIME_TCP)

	int
daytime_tcp_main (int argc, char * argv[])
{
	return (daytime_main(MULTISERV_TCP, argc, argv));
}

	int
daytime_tcp_description (FILE * stream)
{
	return (fprintf(stream, "Daytime rfc.867 (TCP/IP)"));
}

	static int
daytime_tcp_dialog (int sock, struct sockaddr_in * unused_client_address)
{
	int n;
	time_t tm;
	multiserv_log(MULTISERV_LOG_MESSAGE, "daytime", "New TCP connection");
	time (& tm);
	if (gmt_time) {
		n = strftime (multiserv_buffer, MULTISERV_BUFFER_LEN, format, gmtime(& tm));
	} else {
		n = strftime (multiserv_buffer, MULTISERV_BUFFER_LEN, format, localtime(& tm));
	}
	if (n <= 0) {
		multiserv_log(MULTISERV_LOG_ERROR, "daytime", "error in strftime format");
		return (1);
	}
	send (sock, multiserv_buffer, n, 0);
	return (0);
}

#endif

/***********************************************************************
     UDP/IP routines
 **********************************************************************/

#if defined(MULTISERV_DAYTIME_UDP)

	int
daytime_udp_main (int argc, char * argv[])
{
	return (daytime_main(MULTISERV_UDP, argc, argv));
}  

	int
daytime_udp_description (FILE * stream)
{
	return (fprintf(stream, "Daytime rfc.867 (UDP/IP)"));
}

	static int
daytime_udp_dialog (int sock, struct sockaddr_in * client_address, int unused_size)
{
	int n;
	time_t tm;
	multiserv_log(MULTISERV_LOG_MESSAGE, "daytime", "New UDP datagram");
	time (& tm);
	if (gmt_time) {
		n = strftime (multiserv_buffer, MULTISERV_BUFFER_LEN, format, gmtime(& tm));
	} else {
		n = strftime (multiserv_buffer, MULTISERV_BUFFER_LEN, format, localtime(& tm));
	}
	if (n <= 0) {
		multiserv_log(MULTISERV_LOG_ERROR, "daytime", "error in strftime format");
		return (1);
	}
	sendto (sock, multiserv_buffer, n, 0, (struct sockaddr *) client_address ,sizeof(struct sockaddr_in));
	return (0);
}

#endif

/***********************************************************************
     Common routines
 **********************************************************************/

#if defined(MULTISERV_DAYTIME_TCP) || defined(MULTISERV_DAYTIME_UDP)

	static int
daytime_main (int proto, int argc, char * argv[])
{
	int i, j;
	
	i = 1;
	j = 1;
	while (i < argc) {
		if (argv[i][0] == '-') {
			switch (argv[i][j]) {
				case 'l' :
					gmt_time = 0;
					if (argv[i][++j] == '\0') {
						i ++;
						j = 1;
					}
					continue;
				case 's' :
					if ((argv[i][j+1] != '\0')
					 || (i == argc - 1)) {
						multiserv_log(MULTISERV_LOG_ERROR, "daytime", "Option -s needs an argument");
						return (1);
					 }
					 format = argv[i+1];
					 i += 2;
					 j = 1;
					 continue;
				 case 'h':
				default :
					break;
			}
			multiserv_usage_global_options(argv[0]);
			fprintf(stderr, "  -s <fmt>   Format for date and time as in strftime(3)\n");
			fprintf(stderr, "  -l         Use local time instead of GMT.\n");
			return(1);
		}
	}
#if defined(MULTISERV_DAYTIME_UDP)
	if (proto == MULTISERV_UDP) {
		multiserv_log(MULTISERV_LOG_MESSAGE, "daytime", "UDP server start");
		return (udp_simple_server(daytime_udp_dialog));
	}
#endif
#if defined(MULTISERV_DAYTIME_TCP)
	multiserv_log(MULTISERV_LOG_MESSAGE, "daytime", "TCP server start");
	return (tcp_server(daytime_tcp_dialog));
#endif
}
#endif
