/************************************************************************\
**  discard.c - Discard Protocol                                        **
**                                                                      **
**  Copyright (c) 2004 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	/* See RFC 863 for information about the DISCARD protocol */

	#include <errno.h>
	#include <getopt.h>
	#include <signal.h>
	#include <stdarg.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/fcntl.h>

	#include "multiserv.h"
	#include "multiserv_utils.h"

	#include "discard.h"

#if defined(MULTISERV_DISCARD_TCP) || defined(MULTISERV_DISCARD_UDP)
	int		discard_main (int proto, int argc, char * argv[]);
#endif

/***********************************************************************
     TCP/IP routines
 **********************************************************************/
	
#if defined(MULTISERV_DISCARD_TCP)

	int
discard_tcp_description (FILE * stream)
{
	return (fprintf(stream, "Discard rfc.863 (TCP/IP)"));
}

	static int
discard_tcp_dialog (int sock, struct sockaddr_in * unused_client_address)
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "discard", "New TCP connection");
	while (recv(sock, multiserv_buffer, MULTISERV_BUFFER_LEN, 0) > 0)
		;
	multiserv_log(MULTISERV_LOG_MESSAGE, "discard", "Connection closed by remote host");
	return (0);
}

	int
discard_tcp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "discard", "TCP server start");
	return (tcp_server(discard_tcp_dialog));
}

#endif

/***********************************************************************
     UDP/IP routines
 **********************************************************************/

#if defined(MULTISERV_DISCARD_UDP)

	int
discard_udp_description (FILE * stream)
{
	return (fprintf(stream, "Discard Protocol rfc.863 (UDP/IP)"));
}

	static int
discard_udp_dialog (int sock, struct sockaddr_in * client_address, int msg_size)
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "discard", "New UDP datagram");
	return (0);
}

	int
discard_udp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "discard", "UDP server start");
	return (udp_simple_server(discard_udp_dialog));
}  

#endif
