/************************************************************************\
**  echo.c - Echo Protocol                           			        **
**                                                                      **
**  Copyright (c) 2004 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	/* See RFC 862 for information about the ECHO protocol */

	#include <errno.h>
	#include <getopt.h>
	#include <signal.h>
	#include <stdarg.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/fcntl.h>

	#include "multiserv.h"
	#include "multiserv_utils.h"

	#include "echo.h"

/***********************************************************************
     TCP/IP routines
 **********************************************************************/
	
#if defined(MULTISERV_ECHO_TCP)

	int
echo_tcp_description (FILE * stream)
{
	return (fprintf(stream, "Echo Protocol rfc.862 (TCP/IP)"));
}

	static int
echo_tcp_dialog (int sock, struct sockaddr_in * unused_client_address)
{
	int n;
	multiserv_log(MULTISERV_LOG_MESSAGE, "echo", "New TCP connection");
	while ((n = recv(sock, multiserv_buffer, MULTISERV_BUFFER_LEN, 0)) > 0)
		send (sock, multiserv_buffer, n, 0);
	multiserv_log(MULTISERV_LOG_MESSAGE, "echo", "Connection closed by remote host");
	return (0);
}

	int
echo_tcp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "echo", "TCP server start");
	return (tcp_server(echo_tcp_dialog));
}

#endif

/***********************************************************************
     UDP/IP routines
 **********************************************************************/

#if defined(MULTISERV_ECHO_UDP)

	int
echo_udp_description (FILE * stream)
{
	return (fprintf(stream, "Echo Protocol rfc.862 (UDP/IP)"));
}

	static int
echo_udp_dialog (int sock, struct sockaddr_in * client_address, int msg_size)
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "echo", "New UDP datagram");
	sendto (sock, multiserv_buffer, msg_size, 0, (struct sockaddr *) client_address,sizeof(struct sockaddr_in));
	return (0);
}

	int
echo_udp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "echo", "UDP server start");
	return (udp_simple_server(echo_udp_dialog));
}  

#endif
