/************************************************************************\
**  qotd.c - Quote Of The Day                                           **
**                                                                      **
**  Copyright (c) 2004 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	/* See RFC 865 for information about the QOTD protocol */

	#include <errno.h>
	#include <getopt.h>
	#include <signal.h>
	#include <stdarg.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <time.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/fcntl.h>

	#include "multiserv.h"
	#include "multiserv_utils.h"

	#include "qotd.h"

#if defined(MULTISERV_QOTD_TCP) || defined(MULTISERV_QOTD_UDP)

	static int	qotd_main (int proto, int argc, char * argv[]);

	static void get_qotd_message	(void);
	
	static time_t	msg_time = 0;
	static int		msg_size = 0;
	static char *	msg = NULL;
	static char *	msg_file = MULTISERV_QOTD_FILE;
	
#endif

/***********************************************************************
     TCP/IP routines
 **********************************************************************/
	
#if defined(MULTISERV_QOTD_TCP)

	int
qotd_tcp_main (int argc, char * argv[])
{
	return (qotd_main(MULTISERV_TCP, argc, argv));
}

	int
qotd_tcp_description (FILE * stream)
{
	return (fprintf(stream, "Quote Of The Day rfc.865 (TCP/IP)"));
}

	static int
qotd_tcp_dialog (int sock, struct sockaddr_in * unused_client_address)
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "qotd", "New TCP connection");
	get_qotd_message ();
	if (msg_size != 0)
		send (sock, msg, msg_size, 0);
	return (0);
}

#endif

/***********************************************************************
     UDP/IP routines
 **********************************************************************/

#if defined(MULTISERV_QOTD_UDP)

	int
qotd_udp_main (int argc, char * argv[])
{
	return (qotd_main(MULTISERV_UDP, argc, argv));
}  

	int
qotd_udp_description (FILE * stream)
{
	return (fprintf(stream, "Quote Of The Day rfc.865 (UDP/IP)"));
}

	static int
qotd_udp_dialog (int sock, struct sockaddr_in * client_address, int unused_size)
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "qotd", "New UDP datagram");
	get_qotd_message ();
	if (msg_size != 0)
		sendto(sock, msg, msg_size,  0, (struct sockaddr *) client_address ,sizeof(struct sockaddr_in));
	return (0);
}

#endif

/***********************************************************************
     Common routines
 **********************************************************************/

#if defined(MULTISERV_QOTD_TCP) || defined(MULTISERV_QOTD_UDP)

	static int
qotd_main (int proto, int argc, char * argv[])
{
	int i;
	
	i = 1;
	while (i < argc) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
				case 'f' :
					if ((argv[i][2] != '\0')
					 || (i == argc - 1)) {
						multiserv_log(MULTISERV_LOG_ERROR, "qotd", "Option -f needs an argument");
						return (1);
					 }
					 msg_file = argv[i+1];
					 i += 2;
					continue;
				case 'q' :
					if ((argv[i][2] != '\0')
					 || (i == argc - 1)) {
						multiserv_log(MULTISERV_LOG_ERROR, "qotd", "Option -q needs an argument");
						return (1);
					}
					msg = realloc (msg, strlen(argv[i+1]) + 2);
					if (msg == NULL)
						exit (1);
					strcpy (msg, argv[i+1]);
					strcat (msg, "\n");
					msg_size = strlen(msg);
					i += 2;
					continue;
				 case 'h':
				default :
					break;
			}
			multiserv_usage_global_options(argv[0]);
			fprintf(stderr, "  -q <str>   String to use as quote of the day\n");
			fprintf(stderr, "  -l <path>  Pathname of quote file instead of %s\n", MULTISERV_QOTD_FILE);
			return (1);
		}
	}
#if defined(MULTISERV_QOTD_UDP)
	if (proto == MULTISERV_UDP) {
		multiserv_log(MULTISERV_LOG_MESSAGE, "qotd", "UDP server start");
		return (udp_simple_server(qotd_udp_dialog));
	}
#endif
#if defined(MULTISERV_QOTD_TCP)
	multiserv_log(MULTISERV_LOG_MESSAGE, "qotd", "TCP server start");
	return (tcp_server(qotd_tcp_dialog));
#endif
}

	static void
get_qotd_message (void)
{
	time_t now;
	FILE * fp;
	char * buf;
	if (msg != NULL) { /* message still there */
		if (msg_time == 0) /* no timeout */
			return;
		time (& now);
		if ((msg_time % 86400) == (now % 86400)) /* still valid */
			return;
		free (msg);
		msg = NULL;
		msg_size = 0;
	}
	if ((fp = fopen (msg_file, "r")) == NULL)
		return;
	while (fgets(multiserv_buffer, MULTISERV_BUFFER_LEN, fp) != NULL) {
		buf = realloc(msg, msg_size + strlen(multiserv_buffer) + 2); /* 2 to have enough space for final \n \0 */
		if (buf == NULL)
			break;
		if (msg == NULL)
			buf[0] = '\0';
		msg = buf;
		strcat (msg,multiserv_buffer);
		msg_size += strlen(multiserv_buffer);
	}
	msg_time = now;
	fclose (fp);
}
#endif
