/************************************************************************\
**  Time.c - Time Protocol                                              **
**                                                                      **
**  Copyright (c) 2004 Christophe Blaess <ccb@club-internet.fr>         **
**    ---------------------------------------------------------------   **
**                                                                      **
** This program is free software; you can redistribute it and/or modify **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation.                                        **
**                                                                      **
**  This program is distributed in the hope that it will be useful,     **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, write to the Free Software          **
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA             **
** 02111-1307  USA                                                      **
**                                                                      **
**    ---------------------------------------------------------------   **
**                                                                      **
** Ce programme est libre, vous pouvez le redistribuer et/ou le modifier**
** selon les termes de la Licence Publique Gnrale GNU publie par la  **
** Free Software Foundation.                                            **
**                                                                      **
** Ce programme est distribu car potentiellement utile, mais SANS      **
** AUCUNE GARANTIE, ni explicite ni implicite, y compris les garanties  **
** de commercialisation ou d'adaptation dans un but spcifique.         **
** Reportez-vous  la Licence Publique Gnrale GNU pour plus de dtails**
**                                                                      **
** Vous devez avoir reu une copie de la Licence Publique Gnrale GNU  **
** en mme temps que ce programme ; si ce n'est pas le cas, crivez    **
** la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston **
** MA 02111-1307, tats-Unis.                                           **
**                                                                      **
\************************************************************************/

	/* See RFC 868 for information about the TIME protocol */

	#include <errno.h>
	#include <getopt.h>
	#include <signal.h>
	#include <stdarg.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <time.h>
	#include <unistd.h>
	#include <arpa/inet.h>
	#include <netinet/in.h>
	#include <sys/socket.h>
	#include <sys/types.h>
	#include <sys/fcntl.h>

	#include "multiserv.h"
	#include "multiserv_utils.h"

	#include "time.h"

/***********************************************************************
     TCP/IP routines
 **********************************************************************/
	
#if defined(MULTISERV_TIME_TCP)

	int
time_tcp_description (FILE * stream)
{
	return (fprintf(stream, "Time Protocol rfc.868 (TCP/IP)"));
}

	static int
time_tcp_dialog (int sock, struct sockaddr_in * unused_client_address)
{
	time_t tm;
	long tm2;
	multiserv_log(MULTISERV_LOG_MESSAGE, "time", "New TCP connection");
	time (& tm);
	tm2 = tm;
	tm2 += 2208988800LU; /* 01/01/1970 - 01/01/1900 */
	tm2 = htonl(tm2);
	send (sock, (char *) & tm2, 4, 0);
	return (0);
}

	int
time_tcp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "time", "TCP server start");
	return (tcp_server(time_tcp_dialog));
}

#endif

/***********************************************************************
     UDP/IP routines
 **********************************************************************/

#if defined(MULTISERV_TIME_UDP)

	int
time_udp_description (FILE * stream)
{
	return (fprintf(stream, "Time Protocol rfc.868 (UDP/IP)"));
}

	static int
time_udp_dialog (int sock, struct sockaddr_in * client_address, int unused_size)
{
	time_t tm;
	long tm2;
	multiserv_log(MULTISERV_LOG_MESSAGE, "time", "New UDP datagram");
	time (& tm);
	tm2 = tm;
	tm2 += 2208988800LU; /* 01/01/1970 - 01/01/1900 */
	tm2 = htonl(tm2);
	sendto (sock, (char *) & tm2, 4, 0, (struct sockaddr *) client_address ,sizeof(struct sockaddr_in));
	return (0);
}

	int
time_udp_main (int argc, char * argv[])
{
	multiserv_log(MULTISERV_LOG_MESSAGE, "time", "UDP server start");
	return (udp_simple_server(time_udp_dialog));
}  

#endif
