/***********************************************************************\
   exemple_getsid
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#define _GNU_SOURCE
	#include <stdio.h>
	#include <unistd.h>
	#include <sys/types.h>

	int
main (int argc, char * argv [])
{
	int 	i;
	long int pid;
	long int sid;

	if (argc == 1) {
		fprintf(stdout, "%ld : %ld\n", (long)getpid(), (long)getsid(0));
		return 0;
	}
	for (i = 1; i < argc; i ++)
		if (sscanf(argv[i], "%ld", & pid) != 1) {
			fprintf(stderr, "PID invalide : %s\n", argv[i]);
		} else {
			sid = (long)getsid((pid_t) pid);
			if (sid == -1)
				fprintf(stderr, "%ld inexistant\n", pid);
			else
				fprintf(stderr, "%ld : %ld\n", pid, sid);
		}
	return 0;
}
