/***********************************************************************\
   exemple_setresuid
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#define _GNU_SOURCE

	#include <stdio.h>
	#include <unistd.h>
	#include <sys/types.h>

	int
main (void)
{
    uid_t	uid_R, uid_E, uid_S;

    getresuid(& uid_R, & uid_E, & uid_S);
    fprintf(stdout, " UID-R=%u, UID-E=%u, UID-S=%u\n", uid_R, uid_E, uid_S);

    fprintf(stdout, " setresuid(-1, %u, %u) = %d\n", 
			uid_R, uid_E, setresuid(-1, uid_R, uid_E));

    getresuid(& uid_R, & uid_E, & uid_S);
    fprintf(stdout, " UID-R=%u, UID-E=%u, UID-S=%u\n", uid_R, uid_E, uid_S);

    fprintf(stdout, " setresuid(-1, %u, -1) = %d\n", uid_S,
	             setresuid(-1, uid_S, -1));

    getresuid(& uid_R, & uid_E, & uid_S);
    fprintf(stdout, " UID-R=%u, UID-E=%u, UID-S=%u\n", uid_R, uid_E, uid_S);

    return 0;
}
