/***********************************************************************\
   exemple_waitid
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>
	#include <signal.h>
	#include <errno.h>
	#include <sys/wait.h>
	#include <sys/resource.h>


	int
main (void)
{
	pid_t	pid;
	
	int	i, j;
	
	siginfo_t info;

	switch (pid = fork()) {
		case -1 :
			fprintf(stderr, "Erreur dans fork()\n");
			exit(EXIT_FAILURE);
		case 0 : /* fils */
			fprintf(stdout, "Fils : PID = %ld\n", (long)getpid());
			j = 0;
			for (i = 0; i < 5000000; i ++)
				j += i;
			fprintf(stderr, "Fils va s'arrter\n");
			raise(SIGSTOP);
			
			for (i = 0; i < 500000; i ++) {
				FILE * fp;
				fp = fopen("exemple_waitid", "r");
				if (fp != NULL)
					fclose(fp);
			}
			exit(EXIT_SUCCESS);
		default : /* pre */
			break;
	}

	while (1) {
		sleep(1);
		fprintf(stderr, "Will wait...\n");
		if (waitid(P_ALL, 0, & info, WUNTRACED) == 0) {
			if (WIFEXITED(info.si_status)) {
				fprintf(stdout, "%ld termin par exit (%d)\n",
						(long)pid, WEXITSTATUS(info.si_status));
			} else if (WIFSIGNALED(info.si_status)) {
				fprintf(stdout, "%ld termin par signal %d\n",
						(long)pid, WTERMSIG(info.si_status));
			} else if (WIFSTOPPED(info.si_status)) {
				fprintf(stdout, "%ld stopp par signal %d\n",
						(long)pid, WSTOPSIG (info.si_status));
				fprintf(stdout, "Je le relance\n");
				kill(info.si_pid, SIGCONT);
			}
		} else if (errno == ECHILD) {
			/* Plus de fils */
			break;
		} 
	}
	return EXIT_SUCCESS;
}
