/***********************************************************************\
   exemple_sigaction_1
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <signal.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>
	#include <errno.h>

	void
gestionnaire (int numero)
{
	switch (numero) {
		case SIGQUIT :
			fprintf(stdout, "\nSIGQUIT reu\n"); fflush(stdout);
			break;
		case SIGINT :
			fprintf(stdout, "\nSIGINT reu\n"); fflush(stdout);
			break;
	}
}

	int
main (void)
{
	struct sigaction action;

	action.sa_handler = gestionnaire;
	sigemptyset(& (action.sa_mask));
	action.sa_flags = 0;

	if (sigaction(SIGQUIT, & action, NULL) != 0) {
		fprintf(stderr, "Erreur %d\n", errno);
		exit(EXIT_FAILURE);
	}

	action.sa_handler = gestionnaire;
	sigemptyset(& (action.sa_mask));
	action.sa_flags = SA_RESTART | SA_RESETHAND;

	if (sigaction(SIGINT, & action, NULL) != 0) {
		fprintf(stderr, "Erreur %d\n", errno);
		exit(EXIT_FAILURE);
	}

	/* Lecture continue, pour avoir un appel-systme lent  bloqu */
	while (1) {
		int i;
		fprintf(stdout, "appel read()\n");
		if (read(0, & i, sizeof(int)) < 0)
			if (errno == EINTR)
				fprintf(stdout, "EINTR \n");
	}
	return EXIT_SUCCESS;

}

