/***********************************************************************\
   exemple_sigaction_2
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <signal.h>
	#include <errno.h>

	int
main (void)
{
	int i;
	struct sigaction action;
	for (i = 1; i < NSIG; i ++) {
		if (sigaction(i, NULL, & action) != 0)
			fprintf(stderr, "Erreur sigaction %d\n", errno);
		if (action.sa_handler != SIG_DFL) {
			fprintf(stdout, "%d (%s) comportement ",
				i, sys_siglist[i]);
			if (action.sa_handler == SIG_IGN)
				fprintf(stdout, ": ignorer\n");
			else
				fprintf(stdout, "personnalis\n");
		}
	}
	return EXIT_SUCCESS;
}
