/***********************************************************************\
   exemple_sigqueue
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <signal.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>

	void
syntaxe (const char * nom)
{
	fprintf(stderr, "syntaxe %s signal pid...\n", nom);
	exit(EXIT_FAILURE);
}

	int
main (int argc, char * argv [])
{
	int     i;
	int     numero;
	int		pid;
	union sigval valeur;

	if (argc == 1)
		syntaxe(argv[0]);

	i = 1;

	if (argc == 2) {
		numero = SIGTERM;
	} else {
		if (sscanf(argv[i], "%d", & numero) != 1)
			syntaxe(argv[0]);
		i ++;
	}
	if ((numero < 0) || (numero > NSIG - 1))
		syntaxe(argv[0]);
		
	valeur.sival_int = 0;
	for (; i < argc; i ++) {
		if (sscanf(argv[i], "%d", & pid) != 1)
			syntaxe(argv[0]);
		if (sigqueue((pid_t) pid, numero, valeur) < 0) {
			fprintf(stderr, "%d : ", pid);
			perror("");
		}
	}
	return EXIT_SUCCESS;
}

