/***********************************************************************\
   exemple_setrlimit
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>
	#include <signal.h>
	#include <sys/resource.h>


	int
main (void)
{
#ifdef NDEBUG
	struct rlimit limite;

	if (getrlimit(RLIMIT_CORE, & limite) != 0) {
		fprintf(stderr, "Impossible d'accder  RLIMIT_CORE\n");
		return EXIT_FAILURE;
	}

	limite.rlim_cur = 0;

	if (setrlimit(RLIMIT_CORE, & limite) != 0) {
		fprintf(stderr, "Impossible d'crire RLIMIT_CORE\n");
		return EXIT_FAILURE;
	}
	
	fprintf(stdout, "Code dfinitif, \"core\" vit \n");
#else
	fprintf(stdout, "Code de dveloppement, \"core\" cr si besoin\n");
#endif

	/*
         Et maintenant... on se plante !
	 */

	raise(SIGSEGV);

	return EXIT_SUCCESS;
}
