/***********************************************************************\
   exemple_semaphores_nommes
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <pthread.h>
	#include <semaphore.h>
	#include <unistd.h>
	#include <fcntl.h>

	static int processus (const char * nom);
	static int aleatoire (int maximum);


	int
main (void)
{
	switch (fork()) {
		case -1:
			perror("fork");
			exit(EXIT_FAILURE);
		case 0:
			return processus("Fils");

		default:
			return processus("Pre");
	}
}


	static int
processus (const char * nom)
{
	sem_t * semaphore;
	int    i;
	
	semaphore = sem_open("/mon_semaphore", O_CREAT, 0600, 1);
	if (semaphore == SEM_FAILED) {
		perror(nom);
		exit(EXIT_FAILURE);
	}

	for (i = 0; i < 2; i ++) {
		sem_wait(semaphore);
		fprintf(stdout, "%s dans portion critique\n", nom);
		sleep(aleatoire(4));
		fprintf(stdout, "%s sort de la portion critique\n", nom);
		sem_post(semaphore);
		sleep(aleatoire(4));
	}
	sem_close(semaphore);
	return EXIT_SUCCESS;
}		


	static int
aleatoire (int maximum)
{
	double d;
	d = (double) maximum * rand();
	d = d / (RAND_MAX + 1.0);
	return ((int) d);
}
