/***********************************************************************\
   exemple_signaux
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <signal.h>
	#include <pthread.h>
	#include <unistd.h>

	#define NB_THREADS	5

	static void *	fonction_thread (void * void_arg);
	static void		gestionnaire	(int numero);

	
	int
main (void)
{
	int i;
	static pthread_t thr;
	struct sigaction action;

	fprintf(stdout, "Thread main, mon PID est %ld\n", (long) getpid());

	sigfillset(& action.sa_mask);
	action.sa_handler = gestionnaire;
	action.sa_flags = 0;
	for (i = SIGRTMIN; i < SIGRTMIN+NB_THREADS; i ++) {
		if (sigaction(i, & action, NULL) == 0)
			fprintf(stdout, "Signal %d captur\n", i);
		else
			fprintf(stdout, "Signal %d NON captur\n", i);
	}
	
	for (i = 0; i < 5; i ++) {
		pthread_create(& thr, NULL, fonction_thread, (void *) i);
	}
	
	sleep(1);
	fprintf(stdout, "Thread main, je me termine\n");
	pthread_exit(NULL);
}



	static void *
fonction_thread (void * void_arg)
{
	sigset_t  masque;
	int       numero = (int) void_arg;
	int       i;
	
	fprintf(stdout, "Thread %d, mon PID est %ld\n", numero, (long) getpid());
	
	sigemptyset(& masque);
	for (i = 0; i < NB_THREADS; i ++)
		if (i != numero)
			sigaddset(& masque, SIGRTMIN + i);
	pthread_sigmask(SIG_BLOCK, & masque, NULL);

	fprintf(stdout, "Thread %d bloque tout sauf %d\n", numero, SIGRTMIN+numero);	
	
	while (1)  {
		pause();
		fprintf(stdout, "Thread %d a reu un signal\n", numero);
	}
	return NULL;
}

void gestionnaire(int numero)
{
	fprintf(stdout, ">>> signal %d reu <<<\n", numero);
}

