/***********************************************************************\
   exemple_mcheck_1
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <mcheck.h>

	void	fonction_d_erreur (enum mcheck_status status);

	#define NB_INT	20

	int
main (void)
{
	int * table_int;
	int	i;

	if (mcheck(fonction_d_erreur) != 0) {
		perror("mcheck");
		exit(EXIT_FAILURE);
	}
	fprintf(stdout, "Allocation de la table\n");	
	table_int = calloc(NB_INT, sizeof(int));

	fprintf(stdout, "On dborde vers le haut\n");
	for (i = 0; i <= NB_INT; i ++)
		table_int[i] = 1;
	
	fprintf(stdout, "Libration de la table\n");
	free(table_int);

	fprintf(stdout, "Allocation de la table\n");	
	table_int = calloc(NB_INT, sizeof(int));

	fprintf(stdout, "On dborde vers le bas\n");
	i = NB_INT;
	while (i >= 0)
		table_int[--i] = 1;
	
	fprintf(stdout, "Libration de la table\n");
	free(table_int);

	fprintf(stdout, "Allocation de la table\n");	
	table_int = calloc(NB_INT, sizeof(int));

	fprintf(stdout, "Ecriture normale\n");
	for (i = 0; i < NB_INT; i ++)
		table_int[i] = 0;

	fprintf(stdout, "Libration de la table\n");
	free(table_int);

	fprintf(stdout, "Et re-libration de la table !\n");
	free(table_int);

	return EXIT_SUCCESS;
}

	void
fonction_d_erreur (enum mcheck_status status)
{
	switch (status) {
		case MCHECK_DISABLED :
			fprintf(stdout, " -> Pas de vrification\n");
			break;
		case MCHECK_OK :
			fprintf(stdout, " -> Vrification Ok\n");
			break;
		case MCHECK_HEAD :
			fprintf(stdout, " -> Donnes avant un bloc crases\n");
			break;
		case MCHECK_TAIL :
			fprintf(stdout, " -> Donnes aprs un bloc crases\n");
			break;
		case MCHECK_FREE :
			fprintf(stdout, " -> Bloc dj libr\n");
			break;
	}
}

