/***********************************************************************\
   exemple_strcasestr
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#define _GNU_SOURCE
	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <locale.h>

	int
main (int argc, char * argv[])
{
	int	i;
	char * chaine;

	setlocale(LC_ALL, "");

	if (argc != 3) {
		fprintf(stderr, "Syntaxe : %s chaine sous-chaine\n", argv[0]);
		exit(EXIT_FAILURE);
	}
	if (strlen(argv[2]) == '\0') {
		/* Cela eut arriver si on a lanc le programme avec
		 * un execv() un peu vicieux...
		 */
		fprintf(stderr, "La sous-chaine recherche est vide !\n");
		exit(EXIT_FAILURE);
	}
	i = 0;
	chaine = argv[1];
	while (1) {
		chaine = strcasestr(chaine, argv[2]);
		if (chaine == NULL)
			break;
		/* on saute la sous-chaine trouve */
		chaine += strlen(argv[2]);
		i ++;
	}
	if (i == 0)
		fprintf (stdout, "%s ne se trouve pas dans %s\n",
				argv[2], argv[1]);
	else
		fprintf (stdout, "%s a t trouve %d fois dans %s\n",
				argv[2], i, argv[1]);

	return EXIT_SUCCESS;
}

