/***********************************************************************\
   exemple_ftell
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>

	int
main (void)
{
	long derniere;
	long position;
	int  caractere;
	
	position = ftell(stdin);
	if (position == -1) {
		perror("ftell");
		exit(EXIT_FAILURE);
	}
	derniere = position;
	while ((caractere = getchar()) != EOF) {
		if (caractere == '\n') {
			position = ftell(stdin);
			if (position == -1) {
				perror("ftell");
				exit(EXIT_FAILURE);
			}
			fprintf(stdout, "%ld ", position - derniere - 1);
			derniere = position;
		}
	}
	fprintf(stdout, "\n");
	return EXIT_SUCCESS;
}
