/***********************************************************************\
   exemple_chroot
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>

	void
syntaxe (char * nom)
{
	fprintf(stderr, "Syntaxe %s chemin commande...\n", nom);
	exit(EXIT_FAILURE);
}

	int
main (int argc, char * argv[])
{
	if (argc < 3)
		syntaxe(argv[0]);
	if (chdir (argv [1]) != 0){
		perror("chdir");
		exit(EXIT_FAILURE);
	}
	if (chroot(argv[1]) != 0) {
		perror("chroot");
		exit(EXIT_FAILURE);
	}
	if (seteuid(getuid()) < 0) {
		perror("seteuid");
		exit(EXIT_FAILURE);
	}
	execvp(argv[2], argv + 2);
	perror("execvp");
	return EXIT_FAILURE;
}
 
