/***********************************************************************\
   parcours_dbm
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <gdbm/dbm.h>

	void affiche_contributeur (datum cle, datum donnee);
	
	
	int
main (int argc,char * argv[])
{
	datum  cle;
	datum  donnee;
	
	if (argc != 2) {
		fprintf (stderr, "Syntaxe : %s nom_base \n", argv[0]);
		exit(EXIT_FAILURE);
	}
	if (dbminit(argv[1]) != 0) {
		perror("dbminit");
		exit(EXIT_FAILURE);
	}
	for (cle = firstkey(); cle.dptr != NULL; cle = nextkey(cle)) {
		donnee = fetch(cle);
		if (donnee.dptr != NULL)
			affiche_contributeur(cle, donnee);
	}
	dbmclose();
	return EXIT_SUCCESS;
}

	void
affiche_contributeur (datum cle, datum donnee)
{
	char * nom;
	char * email;
	char * web;
	
	nom = donnee.dptr;
	email = & (nom[strlen(nom) + 1]);
	web   = & (email[strlen(email) + 1]);

	fprintf(stdout, "Numero : %d\n", * ((int *) cle.dptr));
	fprintf(stdout, "  Nom      : %s\n", nom); 
	fprintf(stdout, "  Email    : %s\n", email);
	fprintf(stdout, "  Web      : %s\n", web);
}
