/***********************************************************************\
   exemple_complexe
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <complex.h>
	#include <math.h>
	#include <stdio.h>
	#include <stdlib.h>
	
	int
main(void)
{
	double complex z;
	
	z = 0.5  + I * (sqrt(3)/2);

	fprintf(stdout, "Z : \n");
	fprintf(stdout, "  Partie relle     : %f\n", creal(z));
	fprintf(stdout, "  Partie imaginaire : %f\n", cimag(z));
	fprintf(stdout, "  Module            : %f\n", cabs(z));
	fprintf(stdout, "  Argument          : %f\n", carg(z));

	z = conj(z);		
	
	fprintf(stdout, "\nConjugu de Z : \n");
	fprintf(stdout, "  Partie relle     : %f\n", creal(z));
	fprintf(stdout, "  Partie imaginaire : %f\n", cimag(z));
	fprintf(stdout, "  Module            : %f\n", cabs(z));
	fprintf(stdout, "  Argument          : %f\n", carg(z));

	return EXIT_SUCCESS;
}
