/***********************************************************************\
   exemple_getdomainname
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <errno.h>
	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>

	int
main (void)
{
	char * buffer = NULL;
	size_t taille = 8;

	buffer = malloc(taille);

	while (getdomainname(buffer, taille) != 0) {
		if (errno != ENAMETOOLONG) {
			perror("getdomainname");
			exit(EXIT_FAILURE);
		}
		taille += 8;
		buffer = realloc(buffer, taille);
	}
	fprintf(stdout, "%s\n", buffer);
	free(buffer);
	return EXIT_SUCCESS;
}
