/***********************************************************************\
   exemple_pipe_2
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <unistd.h>
	#include <sys/wait.h>

	int
main (void)
{
	int           tube[2];
	unsigned char buffer[256];
	int           i;

	fprintf(stdout, "Cration tube\n");
	if (pipe(tube) != 0) {
		perror("pipe");
		exit(EXIT_FAILURE);
	}
	switch (fork()) {
		case -1 :
			perror("fork()");
			exit(EXIT_FAILURE);
			break;
		case 0 :
			fprintf(stdout, "Fils : Fermeture entre\n");
			close(tube[1]);
			fprintf(stdout, "Fils : Lecture tube\n");
			if (read(tube[0], buffer, 256) != 256) {
				perror("read");
				exit(EXIT_FAILURE);
			}
			fprintf(stdout, "Fils : Vrification \n");
			for (i = 0; i < 256; i ++)
				if (buffer[i] != i) {
					fprintf(stdout, "Fils : Erreur\n");
					exit(EXIT_FAILURE);
				}
			fprintf(stdout, "Fils : Ok\n");
			break;
		default :
			fprintf(stdout, "Pre : Fermeture sortie\n");
			close(tube[0]);
			for (i = 0; i < 256; i ++)
				buffer[i] = i;
			fprintf(stdout, "Pre : criture dans tube\n");
			if (write(tube[1], buffer, 256) != 256) {
				perror("write");
				exit(EXIT_FAILURE);
			}
			wait(NULL);
			break;
	}
	return EXIT_SUCCESS;
}
