/***********************************************************************\
   exemple_shmctl
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <sys/types.h>
	#include <sys/ipc.h>
	#include <sys/sem.h>
	#include <sys/shm.h>

	#define LG_CHAINE	256

	int
main (int argc, char * argv[])
{
	key_t    key;
	int      sem;
	int      shm;

	if (argc != 2) {
		fprintf(stderr, "Syntaxe : %s fichier_cl \n", argv[0]);
		exit(EXIT_FAILURE);
	}
	if ((key = ftok(argv[1], 0)) == -1) {
		perror("ftok");
		exit(EXIT_FAILURE);
	}
	if (((sem = semget(key, 1, 0)) == -1)
	 || ((shm = shmget(key, LG_CHAINE, 0)) == -1) ) {
		perror("semget/shmget");
		exit(EXIT_FAILURE);
	}
	shmctl(shm, IPC_RMID, NULL);
	semctl(sem, IPC_RMID, 0);
	return EXIT_SUCCESS;
}

