/***********************************************************************\
   exemple_shmread
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <sys/types.h>
	#include <sys/ipc.h>
	#include <sys/sem.h>
	#include <sys/shm.h>

	int
main (int argc, char * argv[])
{
	key_t    key;
	int      sem;
	int      shm;
	struct sembuf sembuf;
	char *   chaine = NULL;

	if (argc != 2) {
		fprintf(stderr, "Syntaxe : %s fichier_cl \n", argv [0]);
		exit(EXIT_FAILURE);
	}
	if ((key = ftok(argv[1], 0)) == -1) {
		perror("ftok");
		exit(EXIT_FAILURE);
	}
	if (((sem = semget(key, 1, 0)) == -1)
	 || ((shm = shmget(key, 0, 0)) == -1) ) {
		perror("semget/shmget");
		exit(EXIT_FAILURE);
	}
	if ((chaine = shmat(shm, NULL, SHM_RDONLY)) == (void *)-1) {
		perror("shmat");
		exit(EXIT_FAILURE);
	}
	sembuf.sem_num = 0;
	sembuf.sem_op  = -1;
	sembuf.sem_flg = 0;
	if (semop(sem, & sembuf, 1) < 0) {
		perror("semop");
		exit(EXIT_FAILURE);
	}
	fprintf(stdout, "%s\n", chaine);
	sembuf.sem_op = 1;
	if (semop(sem, & sembuf, 1) < 0) {
		perror("semop");
		exit(EXIT_FAILURE);
	}
	return EXIT_SUCCESS;
}

