/***********************************************************************\
   exemple_shmwrite
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <sys/types.h>
	#include <sys/ipc.h>
	#include <sys/sem.h>
	#include <sys/shm.h>

	#define LG_CHAINE	256

	typedef union semun {
		int                  val;
		struct   semid_ds *  buffer;
		unsigned short int * table;
	} semun_t;	

	int
main (int argc, char * argv[])
{
	key_t         key;
	int           sem;
	int           shm;
	struct sembuf sembuf;
	semun_t       u_semun;
	char *        chaine = NULL;
	unsigned short table [1];
	
	if (argc != 2) {
		fprintf(stderr, "Syntaxe : %s fichier_cl \n", argv[0]);
		exit(EXIT_FAILURE);
	}
	if ((key = ftok(argv[1], 0)) == -1) {
		perror("ftok");
		exit(EXIT_FAILURE);
	}
	if ((shm = shmget(key, LG_CHAINE, IPC_CREAT | 0600)) == -1) {
		perror("shmget");
		exit(EXIT_FAILURE);
	}
	if ((chaine = shmat(shm, NULL, 0)) == (void *)-1) {
		perror("shmat");
		exit(EXIT_FAILURE);
	}
	if ((sem = semget(key, 1, 0)) == -1) {
		if ((sem = semget(key, 1, IPC_CREAT | IPC_EXCL | 0600)) == -1) {
			perror("semget");
			exit(EXIT_FAILURE);
		}
		chaine[0] = '\0';
		table[0] = 1;
		u_semun.table = table;
		if (semctl(sem, 0, SETALL, u_semun) < 0)
			perror("semctl");
	}
	
	sembuf.sem_num = 0;
	sembuf.sem_op  = -1;
	sembuf.sem_flg = SEM_UNDO;
	if (semop(sem, & sembuf, 1) < 0) {
		perror("semop");
		exit(EXIT_FAILURE);
	}
	fprintf(stdout, "> ");
	fgets(chaine, LG_CHAINE, stdin);
	
	sembuf.sem_op = 1;
	if (semop(sem, & sembuf, 1) < 0) {
		perror("semop");
		exit(EXIT_FAILURE);
	}
	return EXIT_SUCCESS;
}

