/***********************************************************************\
   exemple_reception_multicast
 
   Programme d'exemple du livre "Developpement systeme en C sous Linux"
   
   (c) 2000,2005 - Christophe Blaess
 
\***********************************************************************/

	#include <stdio.h>
	#include <stdlib.h>
	#include <string.h>
	#include <unistd.h>

	#include <arpa/inet.h>
	#include <netdb.h>
	#include <netinet/in.h>

	#include <sys/types.h>
	#include <sys/socket.h>

	#define LG_BUFFER	1024

	int lecture_arguments (int argc, char * argv [], struct sockaddr_in * adresse, char * protocole);

	int
main (int argc, char * argv[])
{
	struct ip_mreq     requete_multicast;
	char               buffer [LG_BUFFER];
	struct sockaddr_in adresse;
	int                nb_lus;
	int                sock;
	
	if (lecture_arguments(argc, argv, & adresse, "udp") < 0)
		exit(EXIT_FAILURE);
	adresse.sin_family = AF_INET;
	if ((sock = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
		perror("socket");
		exit(EXIT_FAILURE);
	}

	requete_multicast.imr_multiaddr.s_addr = adresse.sin_addr.s_addr;
	requete_multicast.imr_interface.s_addr = htons(INADDR_ANY);

	adresse.sin_addr.s_addr = htons(INADDR_ANY);
	if (bind(sock, (struct sockaddr *) & adresse, sizeof(struct sockaddr_in)) < 0) {
		perror("bind");
		exit(EXIT_FAILURE);
	}
	
	if (setsockopt(sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, & requete_multicast, sizeof(struct ip_mreq)) < 0) {
		perror("setsockopt(IP_ADD_MEMBERSHIP)");
		exit(EXIT_FAILURE);
	}

	setvbuf(stdout, NULL, _IONBF, 0);
	while (1) {
		if ((nb_lus = recv(sock, buffer, LG_BUFFER, 0)) == 0)
			break;
		if (nb_lus < 0) {
			perror("read");
			break;
		}
		write(STDOUT_FILENO, buffer, nb_lus);
	}
	return EXIT_SUCCESS;
}


	int
lecture_arguments (int argc, char * argv[], struct sockaddr_in * adresse, char * protocole)
{
	char * liste_options = "a:p:h";
	int    option;
	
	char * hote  = "localhost";
	char * port = "2000";

	struct hostent * hostent;
	struct servent * servent;

	int    numero;

	while ((option = getopt(argc, argv, liste_options)) != -1) {
		switch (option) {
			case 'a' :
				hote  = optarg;
				break;
			case 'p' :
				port = optarg;
				break;
			case 'h' :
				fprintf(stderr, "Syntaxe : %s [-a adresse] [-p port] \n",
						argv[0]);
				return -1;
			default	: 
				break;
		}
	}
	memset(adresse, 0, sizeof(struct sockaddr_in));
	if (inet_aton(hote, & (adresse->sin_addr)) == 0) {
		if ((hostent = gethostbyname(hote)) == NULL) {
			fprintf(stderr, "hte %s inconnu \n", hote);
			return -1;
		}
		adresse->sin_addr.s_addr = ((struct in_addr *) (hostent->h_addr))->s_addr; 
	}
	if (sscanf(port, "%d", & numero) == 1) {
		adresse->sin_port = htons(numero);
		return 0;
	}
	if ((servent = getservbyname(port, protocole)) == NULL) {
		fprintf(stderr, "Service %s inconnu \n", port);
		return -1;
	}
	adresse->sin_port = servent->s_port;
	return 0;
}

