#! /bin/sh

# Verification que l'utilisateur soit bien root
i=$(id -u)
if [ $? -ne 0 ]; then exit 1; fi
if [ "$i" -ne 0 ]
then
  echo "L'installation doit se faire sous root" >&2
  exit 2
fi
# Ajouter ici les eventuelles actions avant
# deploiement de l'archive (sauvegarde des fichiers,
# precedents, creation d'utilisateur, etc.)
# Extraction du fichier d'archive dans le script
base64 -d > /tmp/install.tar.gz <<-END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END
if [ $? -ne 0 ]; then exit 3; fi

# Decompression de l'archive
cd /
tar xzf /tmp/install.tar.gz || exit 4
rm -f /tmp/install.tar.gz
# Ajouter ici les eventuelles actions apres
# deploiement de l'archive (liens symboliques, etc.)
