#! /bin/sh

function explore_repertoire
{
	local f
	local i
	# Prcder le nom du rpertoire transmis en premier argument
	# par autant de blancs que la valeur du second argument.
	declare -i i
	i=0
	while [ $i -lt $2 ] ; do
		echo -n " "
		i=$((i + 1))
	done
	echo "$1"
	# Se dplacer dans le premier rpertoire. Si chec -> abandon
	if ! cd "$1" ; then return ; fi
	# Balayer tout le contenu du rpertoire
	for f in * ; do
		# Sauter les liens symboliques
		if [ -L "$f" ] ; then
			continue
		fi
		# Si on a trouv un sous-rpertoire, l'explorer en
		# incrmentant sa position (de 4 pour faire plus joli)
		if [ -d "$f" ] ; then
			explore_repertoire "$f" $(($2 + 4))
		fi
	done
	# Revenir dans le rpertoire initial
	cd ..
}

# Lancer l'exploration  partir de l'argument
explore_repertoire "$1" 0 
